<?php


namespace WPG\Gateway\Controller\Url;

use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;

/**
 * 
 * Class Index
 * @package WPG\Gateway\Controller\Ipn
 */
class Response extends \WPG\Gateway\Controller\AbstractAction implements CsrfAwareActionInterface
{

    /**
     * Instantiate IPN model and pass IPN request to it
     *
     * @return void
     */
    public function execute()
    {
        if (!$this->getRequest()->isPost()) {
            return;
        }

        try {
          $ipn = $this->getObjectManager()->create(
              "WPG\\Gateway\\Model\\Ipn\\WpgGatewayIpn"
          );
          $data = $this->getRequest()->getPostValue();
          $responseBody = $ipn->handleWpgGatewayNotification($data);
          $this->getResponse()
              ->setHeader('Content-type', 'text/html')
              ->setBody($responseBody['body'])
              ->setHttpResponseCode($responseBody['code'])
              ->sendResponse();
        } catch (\Exception $e) {
            $this->getLogger()->critical($e);
            $this->getResponse()->setHttpResponseCode(500);
        }
    }

    /**
     * @inheritDoc
     */
    public function createCsrfValidationException(RequestInterface $request): ?InvalidRequestException
    {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }
}
